// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "vertexVersionSimple.h"
#include "uniformWorldConstants.h"
#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"

attribute POS4 POSITION;

#include "flora.h"

#if CELESTIAL
varying highp vec3 bgp;
#endif

void main(){
    gl_Position = WORLDVIEWPROJ * POSITION;
  #if CELESTIAL
    highp vec3 bgc = POSITION.xyz;
    bgp = vec3(bgc.x,-bgc.y + 0.128,-bgc.z);
  #endif
}
